/**
 * Proof of concept implementation:
 *
 * - Pointers are stored in a simple array.  For production code, a suitable
 *   efficient data structure, such as a hash table, should be used.
 *
 * - The implementation is not thread-safe.
 */

#include <stdlib.h>

#include "xptr.h"

/**
 * \brief   Stores the xptrs.
 */
static xptr_store_entry m_xptr_store[XPTR_STORE_SIZE];

/**
 * \brief   Determines the next free entry's index in the store.
 */
static inline int xptr_get_next_unused_entry_idx(void);

xptr *xptr_create(const void *const p)
{
    if (p == NULL)
        return NULL;
    int idx = xptr_get_next_unused_entry_idx();
    if (idx == XPTR_ERROR_STORE_FULL)
        return NULL;
    m_xptr_store[idx].target = (void *const)p;
    m_xptr_store[idx].used = true;
    return &m_xptr_store[idx].target;
}

void xptr_null(const void *const p)
{
    if (p == NULL)
        return;
    for (int i = 0; i < XPTR_STORE_SIZE; i++)
        if (m_xptr_store[i].target == p)
            m_xptr_store[i].target = NULL;
}

void xptr_free(const xptr *const xp)
{
    if (xp == NULL)
        return;
    for (int i = 0; i < XPTR_STORE_SIZE; i++)
        if (&m_xptr_store[i].target == xp)
        {
            m_xptr_store[i].target = NULL;
            m_xptr_store[i].used = false;
            return;
        }
}

static inline int xptr_get_next_unused_entry_idx(void)
{
    for (int i = 0; i < XPTR_STORE_SIZE; i++)
        if (!m_xptr_store[i].used)
            return i;
    return XPTR_ERROR_STORE_FULL;
}
