#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "xptr.h"

static void printptr(const char *const name, const void *const p);

static void printxptr(const char *const name, const xptr *const xp);

int main(void)
{
    printf("Allocate string s1.\n");
    char *s1 = malloc(sizeof(char) * 20);
    strcpy(s1, "Hello World!");
    printptr("s1", s1);
    char *s2 = malloc(sizeof(char) * 20);
    printf("Allocate string s2.\n");
    strcpy(s2, "Goodbye World!");
    printptr("s2", s2);
    printf("Create xptr xp1 for string s1.\n");
    xptr *xp1 = xptr_create(s1);
    printf("Create xptr xp2 for string s1.\n");
    xptr *xp2 = xptr_create(s1);
    printf("Create xptr variable xp1_c and assign xp1.\n");
    xptr *xp1_c = xp1;
    printf("Create xptr xp3 for string s2.\n");
    xptr *xp3 = xptr_create(s2);
    printxptr("xp1", xp1);
    printxptr("xp2", xp2);
    printxptr("xp1_c", xp1_c);
    printxptr("xp3", xp3);
    printf("Set xptrs for s1 to NULL.\n");
    xptr_null(s1);
    printxptr("xp1", xp1);
    printxptr("xp2", xp2);
    printxptr("xp1_c", xp1_c);
    printxptr("xp3", xp3);
    printf("Free xptr xp3.\n");
    xptr_free(xp3);
    printxptr("xp3", xp3);
    xp3 = NULL;
    printf("Free xptrs xp1 and xp2.\n");
    xptr_free(xp1);
    printxptr("xp1", xp1);
    xptr_free(xp1);
    xp1 = NULL;
    printxptr("xp2", xp2);
    xp2 = NULL;
    printf("Create xptr xp4 for string s1.\n");
    xptr *xp4 = xptr_create(s1);
    printxptr("xp4", xp4);
    printf("Free xptr xp4.\n");
    xptr_free(xp4);
    printxptr("xp4", xp4);
    xp4 = NULL;
    free(s1);
    s1 = NULL;
    free(s2);
    s2 = NULL;
    return EXIT_SUCCESS;
}

static void printptr(const char *const name, const void *const p)
{
    printf("name: %s; ptr: %p\n", name, p);
}

static void printxptr(const char *const name, const xptr *const xp)
{
    printf("name: %s; xptr: %p; *xptr: %p\n", name, (void *const)xp, *xp);
}
